(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7022,        201]*)
(*NotebookOutlinePosition[      7994,        236]*)
(*  CellTagsIndexPosition[      7922,        230]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(?Arrow\)\)], "Input"],

Cell[BoxData[{
    \(vector2D[x_: {0, 0}, y_] := Arrow[x, x + y]\ \), "\n", 
    \(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \), "\n", 
    \(\(normaliza[x_]\  := 
        If[Simplify[x . x] == 0, x, \ x/norma[x]];\)\ \n\), "\n", 
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input",
  InitializationCell->True],

Cell["\<\
pendulo[longitud_,angulo_,opts___]:=
Module[
{centro:={longitud Sin[angulo],-longitud Cos[angulo]}},

Show[

Graphics[{Thickness[.003],
Line[{{0,0},{0,-(longitud+3)}}]}],

Graphics[{Hue[.65],Thickness[.03],
Line[{{-5,-(longitud+3)},{5,-(longitud+3)}}]}],

Graphics[{Thickness[.0065],Line[{{0,0},centro}]}],

Graphics[{Hue[0],
Disk[centro,longitud/15]}],

Graphics[{PointSize[.015],
Point[centro]}],

Graphics[{PointSize[.02],Point[{0,0}]}],

ParametricPlot[0.5 longitud \
{Sin[s],-Cos[s]},{s,0,If[angulo===0,.000001,angulo]},
    DisplayFunction\[Rule]Identity],

Graphics[If[opts==={},{Text[\"y(t)\", 
         .6 longitud {Sin[angulo/2],-Cos[angulo/2]}], 
        Text[\"L\", 
          0.4 longitud {Sin[angulo],-Cos[angulo]} + {Cos[angulo], \
Sin[angulo]}]},Text[\" \",{0,0}]]],

AspectRatio->Automatic,
PlotRange->{{-(longitud+3),longitud+3},{-(longitud+4),(longitud/2)}},
AxesOrigin->{0,0},TextStyle\[Rule]{FontFamily\[Rule]\"Times\",FontSize\[Rule]\
10},DisplayFunction->Identity]
]\
\>", "Input"],

Cell[BoxData[
    \(\(Show[pendulo[10, \[Pi]/6, 1], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[{pendulo[10, \[Pi]/6, 1], Graphics[Circle[{0, 0}, 10]]}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[BoxData[
    \(Show[Graphics[{vector2D[punto, tu], vector2D[punto, nu]}]]\)], "Input"],

Cell[BoxData[{
    \(\(tra[t_] = 5 {Sin[t], \(-Cos[t]\)};\)\), "\[IndentingNewLine]", 
    \(\(punto = tra[N[Pi]/3];\)\), "\[IndentingNewLine]", 
    \(\(tu = tgtunit[tra, N[Pi]/3];\)\), "\[IndentingNewLine]", 
    \(\(nu = normalunit[tra, N[Pi]/3];\)\), "\[IndentingNewLine]", 
    \(\(Show[{pendulo[5, \[Pi]/3], 
          Graphics[{Circle[{0, 0}, 5], vector2D[punto, {0, \(-4\)} . tu*tu], 
              vector2D[punto, nu . {0, \(-4\)}*nu], 
              vector2D[punto, \(-nu . {0, \(-4\)}\)*nu], 
              vector2D[punto, {0, \(-4\)}], Text["\<mg\>", {5.5, \(-4.8\)}], 
              Text["\<O\>", {0,  .9}]}]}, ImageSize \[Rule] {144, 103.5}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell[BoxData[{
    \(\(Do[
        Show[pendulo[10, ang, 1], 
          DisplayFunction \[Rule] $DisplayFunction], {ang, \(-Pi\)/2, Pi/2, 
          Pi/16}];\)\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[BoxData[
    \(\(\(periodiza[f_, a_, b_]\)[x_] := f[Mod[x, b - a, a]];\)\)], "Input"],

Cell[BoxData[{
    \(\(rec[a_:  0, b_:  1]\)[
        t_] := \(\(UnitStep[t + b/2 - a]\)\(-\)\(UnitStep[
          t - b/2 - a]\)\(\ \)\( (*\ 
          la\ funci\[OAcute]n\ caracter\[IAcute]stica\ del\ intervalo\ \
centrado\ en\ a\ de\ longitud\ b\ *) \)\(\ \)\)\), "\[IndentingNewLine]", 
    \(\(tri[a_:  0, b_:  1]\)[
        t_] := \((1 - Abs[2 \((t - a)\)/b])\)*\(rec[a, b]\)\ [
          t]\), "\[IndentingNewLine]", 
    \( (*\ 
      la\ funci\[OAcute]n\ tri\[AAcute]ngulo\ centrada\ en\ a\ de\ base\ [
          a - b/2, a + b/2]\ *) \)}], "Input"],

Cell[BoxData[
    \(\(Plot[\(tri[Pi/2, Pi]\)[t] - \(tri[\(-Pi\)/2, Pi]\)[t], {t, \(-4\), 
          4}, PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[{
    \(\(func[
          t_] = \(tri[Pi/2, Pi]\)[t] - \(tri[\(-Pi\)/2, Pi]\)[
            t];\)\), "\[IndentingNewLine]", 
    \(\(f[t_] = \(periodiza[func, \(-Pi\), Pi]\)[
          t];\)\), "\[IndentingNewLine]", 
    \(\(Plot[f[t], {t, \(-4\) Pi, 4  Pi}, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[BoxData[{
    \(\(\(newfunc[a_, b_]\)[
          t_] := \(tri[a, b]\)[t] - \(tri[\(-a\), b]\)[
            t];\)\), "\[IndentingNewLine]", 
    \(\(newf[t_, a_, b_] = \(periodiza[newfunc[a, b], \(-2\) a, 2  a]\)[
          t];\)\)}], "Input"],

Cell[BoxData[
    \(\(Plot[newf[t, Pi/2, Pi], {t, \(-4\) Pi, 4  Pi}, 
        PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[{
    \(\(Do[
        Show[pendulo[10, newf[t, Pi/4, Pi/2], 1], 
          DisplayFunction \[Rule] $DisplayFunction], {t, \(-2\) Pi, 2  Pi, 
          Pi/20}];\)\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[BoxData[{
    \(\(posicion[t_, L_, y_] = 
        L\ *{Sin[y[t]], \(-Cos[y[t]]\)};\)\), "\[IndentingNewLine]", 
    \(D[%, t]\)}], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[1754, 51, 85, 2, 93, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[1842, 55, 86, 2, 93, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 7698, 219}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 85, 2, 93, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[1842, 55, 86, 2, 93, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[1931, 59, 43, 1, 94, "Input"],
Cell[1977, 62, 511, 10, 273, "Input",
  InitializationCell->True],
Cell[2491, 74, 1014, 38, 921, "Input"],
Cell[3508, 114, 118, 2, 72, "Input"],
Cell[3629, 118, 150, 2, 120, "Input"],
Cell[3782, 122, 91, 1, 94, "Input"],
Cell[3876, 125, 723, 11, 302, "Input"],
Cell[4602, 138, 380, 7, 176, "Input"],
Cell[4985, 147, 90, 1, 72, "Input"],
Cell[5078, 150, 558, 11, 150, "Input"],
Cell[5639, 163, 142, 2, 94, "Input"],
Cell[5784, 167, 320, 7, 146, "Input"],
Cell[6107, 176, 247, 5, 120, "Input"],
Cell[6357, 183, 116, 2, 94, "Input"],
Cell[6476, 187, 395, 7, 198, "Input"],
Cell[6874, 196, 144, 3, 98, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

